@echo off
setlocal

REM Enter backend directory robustly (no /d switch)
pushd "%~dp0backend" || goto :fail

REM Browser selection: prefer system Chrome, fallback to portable 115
set "SYSTEM_CHROME=C:\Program Files\Google\Chrome\Application\chrome.exe"
set "PORTABLE_CHROME=%~dp0browsers\chrome\chrome.exe"

if exist "%SYSTEM_CHROME%" (
  set "BROWSER_BIN=%SYSTEM_CHROME%"
) else if exist "%PORTABLE_CHROME%" (
  set "BROWSER_BIN=%PORTABLE_CHROME%"
)

if defined BROWSER_BIN (
  set "CHROME_PATH=%BROWSER_BIN%"
  set "PUPPETEER_EXECUTABLE_PATH=%BROWSER_BIN%"
  echo Using browser: %BROWSER_BIN%
)

REM Prefer bundled Node, fallback to system PATH
set "NODE_BIN=%~dp0backend\nodejs\node.exe"
if exist "%NODE_BIN%" (
  "%NODE_BIN%" "%~dp0backend\puppeteer-service.cjs"
) else (
  node "%~dp0backend\puppeteer-service.cjs"
)

if errorlevel 1 (
  echo Start failed, see log: %cd%\logs\service.log
  pause
)

popd
goto :eof

:fail
echo Backend directory missing: %~dp0backend
pause